
rm(list=ls())
library(dplyr)


dat = read.csv("Figure1.csv", header=TRUE)

dat$country = as.character(dat$country)


width=3200
height=2400
res = 300
time = 2007:2016


##############################################################
# Create not.in function to make life easier
##############################################################
`%not.in%` <- function(x,y)!('%in%'(x,y))


##############################################################
# Delete Incomplete Countries
##############################################################

num.missing <- function(x) {
  return (sum(is.na(x)))
}

dat.temp = dat
out = aggregate(x=dat.temp, by=list(country=dat.temp$country), FUN=num.missing)

has.missing = rowSums((out[,-1])) > 0
countries.without.missing = out$country[!has.missing]

dat = dat[dat$country %in% countries.without.missing,]

dat.muslim = dat[dat$muslim==1, ]
list.unique = c(unique(dat.muslim$country))


##############################################################
######### DRAW 
##############################################################

draw <- function(x.range, ylim, ylab, dat1, dat2, dat3, dat4=NULL, legend.lab) {
  plot(x.range, dat1$x,
       type="l", ylim=ylim, 
       lty="solid",
       ylab = ylab,
       xlab ="Year",
       lwd=4,
       axes = FALSE,
       cex.lab = 1.5
  )
  axis(side=1, at=seq(time[1], time[length(time)], 1))
  axis(side=2, at=seq(ylim[1], ylim[2], 1))
  
  lines(x.range, dat2$x, lwd=4, lty="dashed")  
  lines(x.range, dat3$x, lwd=4, lty="dotted")  
  #lines(x.range, dat4$x, lwd=4, lty="dotdash")  
  
  
  legend(x="topright",
         legend=legend.lab,
         #lty=c("solid","dashed","dotted","dotdash"),
         lty=c("solid","dashed","dotted"),
         col="black",
         cex=1.4,bg="white",lwd=2)
}




##############################################################
# Plot
##############################################################

dependent = "SHI"

#christian-majority
agg.christian = aggregate( dat[dat$pctChristian>.5, dependent], 
                           by=list(year=dat$year[dat$pctChristian>.5]),
                           mean, na.rm=TRUE)

#muslim-majority
agg.muslim = aggregate( dat[dat$pctMuslim>=.5, dependent], 
                           by=list(year=dat$year[dat$pctMuslim>=.5]),
                           mean, na.rm=TRUE)

#nonmuslim-majority
agg.nonmuslim = aggregate( dat[dat$pctMuslim<.5, dependent], 
                           by=list(year=dat$year[dat$pctMuslim<.5]),
                           mean, na.rm=TRUE)

#non-muslim, non-Europe-majority
agg.nonwestern = aggregate( dat[dat$pctMuslim<.5 & dat$Region6 %not.in% c("Europe","North America"), dependent], 
                           by=list(year=dat$year[dat$pctMuslim<.5  & dat$Region6 %not.in% c("Europe","North America")]),
                           mean, na.rm=TRUE)


png(filename = "Figure 1. Trends of Social Hostilities Index.png", width=width, height=height, res=res)
    draw(x.range = time, 
         ylim = c(0,10), 
         ylab = "Social Hostilities",
         dat1 = agg.muslim,
         dat2 = agg.christian,
         dat3 = agg.nonmuslim,
         dat4 = agg.nonwestern,
         legend.lab = c("Muslim-Majority Countries","Christian-Majority Countries","Non-Muslim Majority Countries")
         #legend.lab = c("Muslim Countries","Christian Countries","Non-Muslim Countries","Non-Western, Non-Muslim Countries")
         )
dev.off()

